## -*-Tcl-*-
 # ###################################################################
 #  CSS mode - tools for editing CSS documents
 # 
 #  FILE: "cssMode.tcl"
 #                                    created: 97-03-01 17.02.41 
 #                                last update: 01-12-09 19.41.41 
 #  Author: Johan Linde
 #  E-mail: <alpha_www_tools@go.to>
 #     www: <http://go.to/alpha_www_tools>
 #  
 # Version: 2.1.4
 # 
 # Copyright 1997-2001 by Johan Linde
 #  
 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.
 # 
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # 
 # ###################################################################
 ##

#===============================================================================
# This is the main file for CSS mode
#===============================================================================

alpha::mode CSS 2.1.4 cssMode {*.css *.CSS} {
	cssMenu electricBraces electricSemicolon electricReturn electricTab
} {
	addMenu cssMenu 150
} uninstall {
	if {[askyesno "This will uninstall both HTML and CSS modes. Continue?"] == "no"} {return}
	set folder [file dirname [procs::find htmlMenu]]
	if {![file exists $folder]} {return}
	catch {file delete [file join $folder *]}
	catch {file delete $folder}
	catch {file delete [file join $HOME Tcl Completions HTMLCompletions.tcl]}
	catch {file delete [file join $HOME Tcl Completions CSSCompletions.tcl]}
	catch {file delete [file join $HOME Help "HTML Help.tcl"]}
	catch {file delete [file join $HOME Help "HTML Help" "bilder" *]}
	catch {file delete [file join $HOME Help "HTML Help" "Style Sheet" *]}
	catch {file delete [file join $HOME Help "HTML Help" "text" *]}
	catch {file delete [file join $HOME Help "HTML Help" *]}
	catch {file delete [file join $HOME Help "HTML Help"]}
} maintainer {
	"Johan Linde" <alpha_www_tools@go.to> <http://go.to/alpha_www_tools>
} help {file "HTML Help"}

proc cssMode {} {}

namespace eval css {}
namespace eval html {}

newPref f wordWrap 0 CSS
newPref v wordBreak {[-@\w]+} CSS
newPref v wordBreakPreface {[^-@\w]} CSS
# Color of comments
newPref v commentColor red CSS
# Color of CSS keywords
newPref v keywordColor blue CSS
# Color of HTML elements
newPref v htmlColor magenta CSS

# Coloring
proc css::Coloring {{changing 0}} {
	global CSSmodeVars css::Property css::Descriptor
	if {!$changing} {
		regModeKeywords -b {/*} {*/} -c $CSSmodeVars(commentColor) CSS {}
	}
	regModeKeywords -a -k $CSSmodeVars(htmlColor) CSS [css::GetHtmlWords]
	regModeKeywords -a -k $CSSmodeVars(keywordColor) CSS \
	  [concat [array names css::Property] [array names css::Descriptor] \
	  {@font-face important active after before first first-child first-letter 
	first-line focus hover lang left link right visited}]
}

proc css::ChangeColoring {flag} {
	global CSSmodeVars
	switch $flag {
		htmlColor -
		keywordColor {css::Coloring 1}
		commentColor {regModeKeywords -a -c $CSSmodeVars(commentColor) CSS}
	}
	refresh
}

# Load other CSS mode files.
foreach __tmp {cssProperties htmlcssInit htmlMenuDefinition html40} {
	if {[catch {${__tmp}.tcl}]} {
		beep
		alertnote "Loading of ${__tmp}.tcl failed"
		return
	}
}

foreach __vvv [array names CSSmodeVars] {
	set CSSmodeVarsInvisible($__vvv) 1
}

unset __vvv

proc css::DividingLine {} {
	insertText "/*=============================================================================*/\r"
}
Bind 'l' <C> css::DividingLine CSS


proc CSS::electricSemi {} {
	insertText ";\r" [text::indentString [getPos]]
}

proc CSS::parseFuncs {} {
	set pos [minPos]
	set funcExpr {^[ \t]*([^\r\n\{]+)\{}
	while {[set res [search -s -f 1 -r 1 -i 0 -n $funcExpr $pos]] != ""} {
		if {[regexp $funcExpr [eval getText $res] dummy word]} {
			lappend m [list $word [lindex $res 0]]
		}
		set pos [lindex $res 1]
	}
	return [join [lsort -ignore $m]]
}

proc CSS::DblClick {from to} {
	global css::IsDescriptor
	if {![catch {search -s -f 0 -r 1 -m 0 {[ \t\r\n]+[^ \t\r\n;:]+[ \t\r\n]*:} $from} res] && [pos::compare [lindex $res 1] >= $to]} {
		set css::IsDescriptor [css::IsInAtRule font-face]
		css::Dialog [string tolower [string trim [eval getText $res] " \t\r\n:"]]
	} else {
		HTML::DblClick $from $to
	}
}

#===============================================================================
# Preferences
#===============================================================================

proc css::modifyFlags {} {
	global CSSmodeVars HTMLmodeVars alpha::colors
	set diff 0
	if {[info tclversion] >= 8.0} {set diff 20}
	set box "[dialog::title {CSS mode Preferences} 465] \
	  -c {Create missing file without asking when cmd-double-clicking a link} $HTMLmodeVars(createWithoutAsking) 10 [expr {35 - $diff}] 460 [expr {50 - $diff}] \
	  -c {Cmd-double-clicking on non-text file link opens file} $HTMLmodeVars(openNonTextFile) 10 [expr {55 - $diff}] 450 [expr {70 - $diff}] \
	  -c {Use lowercase for HTML element names} $CSSmodeVars(useLowerCase) 10 [expr {75 - $diff}] 450 [expr {90 - $diff}] \
	  -t {Color of keywords:} 10 [expr {100 - $diff}] 150 [expr {115 - $diff}] \
	  -m [list [concat $CSSmodeVars(keywordColor) ${alpha::colors}]] 160 [expr {100 - $diff}] 310 [expr {120 - $diff}] \
	  -t {Color of comments:} 10 [expr {125 - $diff}] 150 [expr {140 - $diff}] \
	  -m [list [concat $CSSmodeVars(commentColor) ${alpha::colors}]] 160 [expr {125 - $diff}] 310 [expr {145 - $diff}] \
	  -t {Color of HTML:} 10 [expr {150 - $diff}] 150 [expr {165 - $diff}] \
	  -m [list [concat $CSSmodeVars(htmlColor) ${alpha::colors}]] 160 [expr {150 - $diff}] 310 [expr {170 - $diff}] \
	  -t wordBreak: 10 [expr {180 - $diff}] 150 [expr {195 - $diff}] \
	  -e [list $CSSmodeVars(wordBreak)] 155 [expr {180 - $diff}] 450 [expr {195 - $diff}] \
	  -t wordBreakPreface: 10 [expr {205 - $diff}] 150 [expr {220 - $diff}] \
	  -e [list $CSSmodeVars(wordBreakPreface)] 155 [expr {205 - $diff}] 450 [expr {220 - $diff}]"
	set values [eval [concat dialog -w 465 -h [expr {265 - $diff}] -b OK 385 [expr {235 - $diff}] 450 [expr {255 - $diff}] \
	  -b Cancel 300 [expr {235 - $diff}] 365 [expr {255 - $diff}] $box]]
	if {[lindex $values 1]} {return}
	for {set i 0} {$i < 7} {incr i} {
		set flag [lindex {createWithoutAsking openNonTextFile useLowerCase keywordColor commentColor htmlColor wordBreak wordBreakPreface} $i]
		global $flag
		set m CSS
		if {$i < 2} {set m HTML}
		set val [lindex $values [expr {$i + 2}]]
		if {[set ${m}modeVars($flag)] != $val} {
			if {[string match "word*" $flag]} {
				set $flag $val
			}
			set ${m}modeVars($flag) $val
			prefs::modifiedModeVar $flag $m
			if {[string match "*Color" $flag]} {css::ChangeColoring $flag}
		}
	}
}

#===============================================================================
#  Initialization  #
#===============================================================================

# Define key bindings from html menu.
proc css::BindingsFromMenu {me tmplist} {
	global htmlMenuKey html${me}Sub
	upvar $tmplist tmp
	foreach it [set html${me}Sub] {
		if {[llength $it] > 2} {
			set elem [lindex $it 2]			
		 	if {[info exists htmlMenuKey(${me}/[lindex $it 1])]} {
				set key $htmlMenuKey(${me}/[lindex $it 1])
			} else {
				set key [lindex $it 0]
			}
			css::BindOneKey $key $elem "" tmp
		}
	}
}

# Define key bindings.
if {[catch {html::ReadCache "CSS keybindings cache"}]} {
	html::ReadMenuKeys
	message "Defining key bindings"
	foreach __tmp [lrange $htmlSubMenus $htmlStartElements end] {
		css::BindingsFromMenu [lindex $__tmp 0] tmplist
	}
	if {[html::NewElementsExists]} {
		html::CreateCustomSub
		css::BindingsFromMenu Custom tmplist
	}
	html::SaveCache "CSS keybindings cache" $tmplist
	unset tmplist
	catch {unset htmlMenuKey}
} else {
	message "Reading key bindings"
}

css::Coloring
rename css::BindingsFromMenu ""
catch {unset __tmp}

# Change mode hook
proc css::ChangeMode {args} {
	css::DisableEnable on
}

hook::register changeMode css::ChangeMode CSS

set CSS::commentCharacters(General) "*"
set CSS::commentCharacters(Paragraph) [list "/* " " */" " * "]
set CSS::commentCharacters(Box) [list "/*" 2 "*/" 2 "*" 3]

set cssModeIsLoaded 1

message "CSS initialization complete."

